#! /bin/csh -f
#
#	Copyright (c) 1995 Cadence Design Systems
#
#	Script generate_dev_list.csh
#		This script takes the Altera package.dat file as input
#		and generates a dev_list.dat file in the current 
#		directory.  If the package.dat file is not specified,
#		./package.dat is assumed.
#
#		This script was written at Cadence and given to Altera
#		so that Altera could use it to create the dev_list.dat
#		file from their standard package.dat file for each release.
#		There is no need for Cadence or Altera to deliver this
#		script to customers.
#
#	Revision History
#		9/7/95 - gazlay - New
#
#	
#	
# Warm Welcoming Message
echo "$0 $1 "
# echo " "
# echo "$0 - Version 1.0 September 7, 1995"
# echo " "
#
# Perform argument checking:  
#	The full path to the package.dat file should be provided
#	as argument $1 and this file must exist.  If it is not
#	provided, assume that it is "./package.dat".
#
if ($#argv < 1) then
	set PackageFile = "./package.dat"
else
	set PackageFile = $1
endif
if (! -e ${PackageFile}) then
    echo "Error: Source Package File Does Not Exist - ${PackageFile}"
    echo "       Script $0 terminated.
    echo " "
    exit 1
endif

#
# Generate the awk script - devlist.awk
#
echo 'BEGIN {' 				> devlist.awk
echo '   family="NONE" ;'		>> devlist.awk
echo '}'				>> devlist.awk
echo '/^FAMILY/ {'			>> devlist.awk
echo '        family=$2 ;'		>> devlist.awk
echo '        print $2 ;'		>> devlist.awk
echo '        print "BEGIN" ;'		>> devlist.awk
echo '        next ;'			>> devlist.awk
echo '}'				>> devlist.awk
echo '/^$/ { next ; }'			>> devlist.awk
echo '/^BEGIN/ { next ; }'		>> devlist.awk
echo '/^END/ {'				>> devlist.awk
echo '        if ( family != "NONE" ) {'	>> devlist.awk
echo '                print "END;" ;'	>> devlist.awk
echo '                print "" ;'	>> devlist.awk
echo '        }'			>> devlist.awk
echo '        family="NONE" ;'		>> devlist.awk
echo '        next ;'			>> devlist.awk
echo '}'				>> devlist.awk
echo 'family == "NONE" { next ; }'	>> devlist.awk
echo '{print $0 ; }'			>> devlist.awk

#
# Execute the awk command to generate dev_list.dat
#
awk -f devlist.awk ${PackageFile} > dev_list.dat

#
# Clean up
#
rm -f devlist.awk

# echo "$0 completed "
echo " "
exit 0
